# صيغ الوقت

يمكنك استخدام صيغة الوقت التي تفضلها عند إدراج الوقت الحالي في الملاحظات.

تساعدك هذه الصفحة في بناء صيغة وقت شخصية مخصصة ليستخدمها التطبيق عند إدراج الوقت الحالي. لاستخدام هذه الصيغة، افتح قائمة _ملاحظة_ > _الإعدادات_ > _المحرر_ > _إدراج الوقت الحالي_، ثم ضعها في خانة «صيغة الوقت».

## تعبيرات التاريخ

| التعبير | الناتج                                                                                                 |
| ------- | ------------------------------------------------------------------------------------------------------ |
| `d`     | اليوم، بغير صفر على اليسار (1 إلى 31)                                                                  |
| `dd`    | اليوم، بصفر على اليسار لجعله من خانتين (01 إلى 31)                                                     |
| `ddd`   | الاسم المختصر ليوم الأسبوع حسب إعدادات النظام (مطابق للاسم الكامل في العربية).                         |
| `dddd`  | الاسم الكامل ليوم الأسبوع حسب إعدادات النظام (مثل `الاثنين` أو `الخميس` في العربية).                   |
| `M`     | رقم الشهر، بغير صفر على اليسار (1 إلى 12)                                                              |
| `MM`    | رقم الشهر، بصفر على اليسار لجعله من خانتين (01 إلى 12)                                                 |
| `MMM`   | الاسم المختصر للشهر الميلادي حسب إعدادات النظام (مطابق للاسم الكامل في العربية).                       |
| `MMMM`  | الاسم الكامل للشهر الميلادي حسب إعدادات النظام (مثل `تشرين الثاني` أو `نوفمبر` في العربية حسب الدولة). |
| `yy`    | العام كرقمين (00 إلى 99)                                                                               |
| `yyyy`  | العام كأربعة أرقام                                                                                     |

## تعبيرات الوقت

| التعبير     | الناتج                                                                                                                |
| ----------- | --------------------------------------------------------------------------------------------------------------------- |
| `h`         | الساعة، بغير صفر على اليسار (0 إلى 23، أو 1 إلى 12 عند عرض ص/م)                                                       |
| `hh`        | الساعة، بصفر على اليسار لجعلها من خانتين (00 إلى 23، أو 01 إلى 12 عند عرض ص/م)                                        |
| `H`         | الساعة، بغير صفر على اليسار (0 إلى 23، حتى عند عرض ص/م)                                                               |
| `HH`        | الساعة، بصفر على اليسار لجعلها من خانتين (00 إلى 23، حتى عند عرض ص/م)                                                 |
| `m`         | الدقيقة، بغير صفر على اليسار (0 إلى 59)                                                                               |
| `mm`        | الدقيقة، بصفر على اليسار لجعلها من خانتين (00 إلى 59)                                                                 |
| `s`         | الثانية، بغير صفر على اليسار (0 إلى 59)                                                                               |
| `ss`        | الثانية، بصفر على اليسار لجعلها من خانتين (00 إلى 59)                                                                 |
| `z`         | المللي ثانية، بغير صفر على اليسار (0 إلى 999)                                                                         |
| `zzz`       | المللي ثانية، بأصفار على اليسار لجعلها من ثلاث خانات (000 إلى 999)                                                    |
| `AP` أو `A` | تُفعّل نمط ١٢ ساعة (بدلًا من ٢٤ ساعة). تُستبدل بأحد الحرفين `ص` أو `م`، للصباح (قبل ١٢ ظهرًا) والمساء (بعد ١٢ ظهرًا). |
| `ap` أو `a` | مثل السابقة تمامًا: تُفعّل نمط ١٢ ساعة، وتُستبدل بأحد الحرفين `ص` أو `م`،                                             |
| `t`         | المنطقة الزمنية (مثلا `CEST`)                                                                                         |

## أمثلة على الصيغ

| الصيغة             | الناتج                                          |
| ------------------ | ----------------------------------------------- |
| `dd.MM.yyyy hh:mm` | 21.05.2001 14:13                                |
| `dd.MM.yyyy`       | 21.05.2001                                      |
| `ddd MMMM d yy`    | الاثنين مايو 21 01 (اسم الشهر يختلف حسب الدولة) |
| `hh:mm:ss.zzz`     | 14:13:09.042                                    |
| `h:m:s ap`         | 2:13:9 م                                        |

::: tip
معلومة ألقِ نظرة على [توثيق Qt (بالإنجليزية)](http://doc.qt.io/qt-5/qdatetime.html#toString) للمزيد من المعلومات عن صيغ الوقت.
:::

::: tip
إذا احتجت إلى عمليات أكثر تعقيدًا لإنتاج الوقت الحالي، فبرجاء النظر في إنشاء [إجراء مخصص](../scripting/methods-and-objects.md#registering-a-custom-action).
:::
