# مُعامِلات واجهة سطر الأوامر

يمكنك استخدام هذه المعاملات في واجهة سطر الأوامر (CLI) للتحكم في سلوك التطبيق:

| المُعامِل                      | الوصف                                                                                         |
| ------------------------------ | --------------------------------------------------------------------------------------------- |
| `‪--help`                      | يُظهر شاشة المساعدة                                                                           |
| `‪--version`                   | يعرض رقم نسخة التطبيق                                                                         |
| `‪--portable`                  | يشغل التطبيق في الوضع المحمول                                                                 |
| `‪--clear-settings`            | يمسح الإعدادات ويشغل التطبيق                                                                  |
| `‪--dump-settings`             | يطبع تفريغ الإعدادات ومعلومات أخرى عن التطبيق والبيئة، بصيغة ماركداون GitHub ويخرج من التطبيق |
| `‪--session <اسم>`       | يشغل التطبيق في سياق مختلف للإعدادات والملفات الداخلية                                        |
| `‪--allow-multiple-instances`  | يسمح بتشغيل عدة نسخ من تطبيق QOwnNotes حتى في حالة منع ذلك في الإعدادات                       |
| `‪--action <اسم>`        | ينفذ إجراء قائمة بعد تشغيل التطبيق (انظر بالأسفل)                                             |
| `‪--completion <الصدفة>` | يولّد أوامر الإكمال الملائمة للصَدفة. يقبل `fish` و&nbsp;`bash`.                              |

::: tip
إذا كنت تواجه مشاكل مع QOwnNotes المثبت لديك، ربما تود أن تشغّل التطبيق بإعدادات جديدة بغير أن تفقد إعداداتك الحالية، باستخدام المُعامل <code dir="ltr">--session</code>.

```bash
QOwnNotes --session test
```

:::

قد تحتاج إلى تشغيل التطبيق من واجهة سطر الأوامر بطرق مختلفة على أنظمة التشغيل المختلفة:

| نظام التشغيل | الأمر                                                                               |
| ------------ | ----------------------------------------------------------------------------------- |
| لينكس        | `QOwnNotes` (أو `qownnotes` لو كان مثبتًا عبر snap)                                 |
| ماك أو إس    | `<span dir="ltr">/Applications/QOwnNotes.app/Contents/MacOS/QOwnNotes</span>` |
| ويندوز       | `QOwnNotes.exe`                                                                     |

::: tip
لنسخ تفريغ الإعدادات إلى الحافظة مباشرةً لنشره في [مسألة أو مشكلة على GitHub](https://github.com/pbek/QOwnNotes/issues)، يمكنك استخدام `xclip` أو `xsel` على لينكس، أو `pbcopy` على macOS، أو `clip` على Windows:

```bash
# انسخ تفريغ الإعدادات إلى الحافظة على لينكس باستخدام xclip
QOwnNotes --dump-settings | xclip -selection clipboard

# انسخ تفريغ الإعدادات إلى الحافظة على لينكس باستخدام xsel
QOwnNotes --dump-settings | xsel --clipboard

# انسخ تفريغ الإعدادات إلى الحافظة على ماك باستخدام pbcopy
QOwnNotes --dump-settings | pbcopy

# انسخ تفريغ الإعدادات إلى الحافظة على ويندوز باستخدام clip
QOwnNotes --dump-settings | clip
```

:::

## تنفيذ إجراءات قائمة بعد التشغيل

باستخدام المُعامِل <code dir="ltr">--action &lt;اسم&gt;</code>، يمكنك تنفيذ إجراءات قائمة بعد تشغيل التطبيق.

مثلا لإظهار حوار قائمة المهام بعد التشغيل، استخدم:

```bash
QOwnNotes --action actionShow_Todo_List
```

::: tip
يمكنك الحصول على أسماء كائنات إجراءات القائمة من [mainwindow.ui](https://github.com/pbek/QOwnNotes/blob/main/src/mainwindow.ui). فقط ابحث بالعنوان الإنجليزي للقائمة. لاحظ أن هذه النصوص قد تتغير بمرور الوقت.
:::

لتنفيذ [إجراء برمجي](../scripting/methods-and-objects.md#registering-a-custom-action)، استخدم <code dir="ltr">customAction_</code> متبوعًا باسم الإجراء المخصص. اسم الإجراء المخصص هو المُعامل الأول في نداء `script.registerCustomAction` في البُريمج.

مثلا لتنفيذ الإجراء المخصص `myAction`، شغّل QOwnNotes هكذا:

```bash
QOwnNotes --action customAction_myAction
```

::: tip
إذا كنت تستخدم وضع النسخة الوحيدة وقمت بتشغيل QOwnNotes مرة ثانية باستخدام مُعامِل الإجراء، فإن إجراء القائمة سيُنفَّذ في النسخة الأولى.
:::
