# Code de Conduite

## Notre serment

Nous, membres, contributeurs et leaders faisont serment de faire de la participation à notre communauté une expérience libre de harcèlement pour toutes les personnes, indépendamment de leur âge, morphologie, handicap visible ou invisible, ethnicité, caractéristiques sexuelles, identité et expression de genre, niveau d'expérience, éducation, statut socio-économique, nationalté, apparence, race, caste, couleur de peau, religion, identité ou orientation sexuelle.

Nous faisons serment d'agir et d'interagir de façon à contribuer à une communauté accueillante, diverse, inclusive et saine.

## Nos standards

Quelques exemples de comportements contribuant à un environnement positif au sein de notre communauté :

- Faire preuve d'empathie et de bienveillance envers les autres personnes
- Respecter les opinions, points de vue et expériences différents
- Donner et accepter de bonne grâce des retours constructifs
- Accepter sa responsabilité et présenter des excuses à ceux affectés par nos erreurs, ainsi qu'apprendre de cette expérience
- Se concentrer sur ce qui est le mieux pour l'ensemble de la communauté et non pas juste pour soi en tant qu'individu

Quelques exemples de comportements inacceptables :

- L'emploi d'un langage ou d'une imagerie sexualisés, des avances ou attentions d'ordre sexuelles et ce quelle que soit leur nature
- Le trolling, les commentaires insultants ou péjoratifs ainsi que les attaques personnelles ou politiques
- Le harcèlement, public ou privé
- La publication d'informations personnelles de tiers sans leur permission explicite, telles que leur adresse postale ou de courriel
- Toutes les autres conduites qui pourraient raisonnablement être considérées inappropriées dans un environnement professionnel

## Responsabilités de mise en application

Les leaders de la communauté sont tenus de clarifier et mettre en œuvre nos standards de comportement acceptables. Ils/elles prendront les mesures correctives justes et appropriées en réponse à tout comportement qu'ils/elles considèreront inapproprié, menaçant, injurieux ou blessant.

Les leaders de la communauté ont le droit et le devoir de retirer, éditer ou rejeter les commentaires, commits, code, modifications du wiki ou toute autre contribution contrevenant au présent Code de Conduite. Ils/elles communiqueront les raisons de la modération quand cela est approprié.

## Périmètre d'application

Le présent Code de Conduite s'applique au sein de tous les espaces communautaires ainsi que quand une personne représente officiellement la communauté dans un espace public. Quelques exemples de représentation : utilisation d'une adresse de courriel officielle, publication sur un réseau social via un compte officiel ou agissement en tant que représentant(e) désigné(e) lors d'un évènement, en personne ou en ligne.

## Mise en application

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the community leaders responsible for enforcement (see _Contact_ menu on [www.qownnotes.org](https://www.qownnotes.org/)). Toutes les plaintes seront examinées et feront l'objet d'une investigation rapide et juste.

Tous les leaders de la communauté sont tenus de faire en sorte que la vie privée et la sécurité de toute personne ayant rapporté un incident soit respectées.

## Mise en application des règles

Les leaders de la communauté suivront ces Règles d'impact Communautaires pour déterminer les conséquences de toute action qu'ils/elles estimeront être en violation du présent Code de Conduite :

### 1. Correction

**Impact sur la Communauté** : l'utilisation d'un langage inapproprié ou de tout autre comportement jugé non-professionnel ou malvenu au sein de la communauté.

**Conséquences** : un avertissement privé écrit des leaders de la communauté, expliquant la nature de la violation et expliquant en quoi le comportement était inapproprié. Des excuses publiques peuvent être demandées.

### 2. Avertissement

**Impact sur la Communauté** : une violation constituée d'un incident isolé ou une série d'actions.

**Conséquences** : un avertissement avec des conséquences pour comportement répété. Aucune interaction avec les personnes impliquées pendant une durée déterminée, incluant les interactions non sollicitées avec celles et ceux mettant en application le Code de Conduite. Ceci inclut l'évitement des interactions dans les espaces communautaires ainsi que via des canaux externes tels que les médias sociaux. La violation de ces termes pourra mener à un bannissement temporaire ou permanent.

### 3. Banissement temporaire

**Impact sur la communauté** : une violation sérieuse des standards de la communauté telle que des comportements inappropriés répétés.

**Conséquence** : un bannissement temporaire prenant la forme d'une interdiction de toute interaction ou communication publique avec la communauté. Aucune interaction privée ou publique durant la durée spécifiée avec les personnes impliquées, incluant celles chargées de la mise en application du Code de Conduite. La violation de ces termes pourra avoir pour conséquence un bannissement permanent.

### 4. Bannissement permanent

**Impact sur la Communauté** : faire preuve d'un ensemble coordonné de comportements en violation des standards de la communauté, tel que des comportements inappropriés, le harcèlement d'un individu, le dénigrement ou la tenue de propos agressifs envers un groupe de personnes.

**Conséquences** : le bannissement permanent et l'interdiction de toute forme d'interaction publique au sein de la communauté.

## Attribution

Ce Code de Conduite est adapté du [Contributor Covenant][homepage] version 2.1, disponible sur [https://www.contributor-covenant.org/version/2/1/code_of_conduct.html][v2.1].

Les Règles d'Impact Communautaires ont été inspirées par le [Mozilla's code of conduct enforcement ladder][Mozilla CoC].

Pour les réponses aux questions les plus fréquemment posées, voir la FAQ disponible sur [https://www.contributor-covenant.org/faq][FAQ]. Des traductions sont disponibles sur [https://www.contributor-covenant.org/translations][translations].

[homepage]: https://www.contributor-covenant.org
[v2.1]: https://www.contributor-covenant.org/version/2/1/code_of_conduct.html
[Mozilla CoC]: https://github.com/mozilla/diversity
[FAQ]: https://www.contributor-covenant.org/faq
[translations]: https://www.contributor-covenant.org/translations
