# 시간 형식

노트에 현재 시간을 삽입할 때 사용자 고유의 시간 형식을 사용할 수 있습니다.

이 페이지를 사용하여 개인 기본 시간 형식을 작성할 수 있습니다. 이 문자열은 _참고_ > _설정_ > _편집기_ > _현재 시간 삽입_입니다.

## 날짜 표현식

| 표현식    | 출력                               |
| ------ | -------------------------------- |
| `d`    | 선행 0이 없는 숫자의 날짜 (1 ~ 31)         |
| `dd`   | 선행 0이 있는 숫자의 날짜 (01 ~ 31)        |
| `ddd`  | 현지화된 약어 날짜 이름 (예: `월`에서 `일`).    |
| `dddd` | 현지화된 긴 요일 이름 (예: `월요일`에서 `일요일`). |
| `M`    | 선행 0이 없는 숫자의 달 (1-12)            |
| `MM`   | 선행 0이 있는 숫자의 달 (01-12)           |
| `MMM`  | 현지화된 달의 약어 이름 (예: `1`에서 `12`).   |
| `MMMM` | 현지화된 긴 달 이름 (예: `1월`에서 `12월`).   |
| `yy`   | 두 자리 숫자의 연도 (00-99)              |
| `yyyy` | 네 자리 숫자의 연도                      |

## 시간 표현식

| 표현식             | 출력                                                                                                                                                                                                                                                                                                                              |
| --------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `h`             | 선행 0이 없는 시간 (오전/오후 표시의 경우 0 ~ 23 또는 1 ~ 12)                                                                                                                                                                                                                                                                                     |
| `hh`            | 선행 0이 있는 시간 (오전/오후 표시의 경우 00 ~ 23 또는 01 ~ 12)                                                                                                                                                                                                                                                                                   |
| `H`             | 선행 0이 없는 시간 (0 ~ 23, 오전/오후 표시가 있는 경우에도)                                                                                                                                                                                                                                                                                         |
| `HH`            | 선행 0이 있는 시간 (00 ~ 23, 오전/오후 표시가 있는 경우에도)                                                                                                                                                                                                                                                                                        |
| `m`             | 선행 0이 없는 분 (0 ~ 59)                                                                                                                                                                                                                                                                                                             |
| `mm`            | 선행 0이 있는 분 (0 ~ 59)                                                                                                                                                                                                                                                                                                             |
| `s`             | 선행 0이 없는 초 (0 ~ 59)                                                                                                                                                                                                                                                                                                             |
| `ss`            | 선행 0이 있는 분 (0 ~ 59)                                                                                                                                                                                                                                                                                                             |
| `z`             | 선행 0이 없는 밀리초 (0 ~ 999)                                                                                                                                                                                                                                                                                                          |
| `zzz`           | 선행 0이 있는 밀리초 (0 ~ 999)                                                                                                                                                                                                                                                                                                          |
| `AP` 또는 `A`     | AM/PM 표시를 사용합니다. A/AP는 `AM` 또는 `PM`로 대체됩니다.                                                                                                                                                                                                                                                                                     |
| `ap` 또는 `a`     | am/pm 표시를 사용합니다. a/ap는 `am` 또는 `pm`로 대체됩니다.                                                                                                                                                                                                                                                                                     |
| `t`             | 표준 시간대 (예: `CEST<0>)</td>
</tr>
</tbody>
</table>

<h2 spaces-before="0">형식 문자열 예제</h2>

<table spaces-before="0">
<thead>
<tr>
  <th>형식</th>
  <th>결과</th>
</tr>
</thead>
<tbody>
<tr>
  <td><code>dd.MM.yyyy hh:mm` | 21.05.2001 14:13 |
| `dd.MM.yyyy`    | 21.05.2001                                                                                                                                                                                                                                                                                                                      |
| `ddd MMMM d yy` | 화 5월 21 01                                                                                                                                                                                                                                                                                                                      |
| `hh:mm:ss.zzz`  | 14:13:09.042                                                                                                                                                                                                                                                                                                                    |
| `h:m:s ap`      | 2:13:9 pm                                                                                                                                                                                                                                                                                                                       |

::: 팁 정보 시간 형식에 대한 자세한 내용은 [Qt 문서](http://doc.qt.io/qt-5/qdatetime.html#toString) 를 참조하십시오. :::

::: 팁 현재 시간을 출력하기 위해 더 복잡한 작업을 수행해야 하는 경우 [사용자 지정 동작](../scripting/methods-and-objects.md#registering-a-custom-action)을 만드는 것을 고려하십시오. :::
