
# Google Season of Doc 2020

Joplin has a young but well proven history. It all started by single idea but is rising more and more commitment as well as demands.

Joplin is about to make another big step to answers these demands by being an organization at Google Summer of Code 2020. 
During the young history of the GSoC campaign it was noticed that it would be a great help if documentation is centralized and making it a continuous read.  The current documentation tells when to do what and how clearly. In addition, the source code of Joplin is clean and well structured, so it is easy to understand. 
Nevertheless, there are additional and essential information scattered around on the Forum and GitHub which rely on an active community, so that are being shared with them who need them. It can be said that this happens very well but it is agreed that this situation has to be improved to free resources for working on the source code and lower entry barriers for new contributors.

For these reasons, all students and Joplin users and developers are welcome to participate in the hopefully first year Summer of Docs program with Joplin. Here's how.

Mentors, administrators and students: read [Season of Docs](https://developers.google.com/season-of-docs) occasionally. Also read the [Season of Docs FAQ](https://developers.google.com/season-of-docs/docs/faq).   
**Most IMPORTANT, read this page carefully, line by line. We don't want to quote paragraphs from this page answering question in the forum.   
Moreover, watch/subscribe the topic [GSoC 2020 live blog](https://discourse.joplinapp.org/t/gsoc-2020-live-blog/6219) as this page here contains rather static content whereas the mentioned topic is updated much more frequently.**

All participants will need a Google account in order to join the program. So, save time and create one now. In addition, all participants need to join the  [Joplin Forum](https://discourse.joplinapp.org).

---

## Instructions for students
Students wishing to participate in Season of Docs must realize, that this is a important professional opportunity. You will be required to produce applicable and readable documentation for Joplin in 3 months. Your mentors, will dedicate a portion of their time to mentoring you. Therefore, we seek candidates who are committed to helping Joplin and its community long-term and are willing to both do quality work, and be proactive in communicating with your mentor(s).

You don't have to be a proven technical writer - in fact, this whole program is meant to facilitate to support Joplin and other Open Source communities by technical writers. However, experience in technical writing and/or coding experience is welcome.

In general it can be said, that question shall be asked early and clearly, given everyone the possibility to understand why you want to have this question answered and how it helps to achieve the project's goal.

Before you can be accepted as a student we expect you to communicate very actively with the community and contributors and summarize what could help them most and link that work on your proposal. 
If your idea is related to codebase documentation it is welcome that you fix little bugs. You may browse the GitHub Issues to find some simple tasks. See the good first issues which are a good way to make yourself familiar with the code base.

You should start learning the components that you plan on working on before the start date. Support can be found in the forum and on our dedicated discourse channel.

Do not worry, the timeline from Google reserves a lot of time for bonding periods so use that time wisely. Good communication is key. To allow us to respond quickly tag your questions with `GSoC-2020`.

You should plan to communicate with your team several times per week, and formally report progress and plans weekly. You are free to chose the format, it can be an sophisticated online document or simple continuous blog on GitHub.

Moreover, we require that you come to clear agreement on how to commit, test and build.

Students who neglect active communication will be failed!


### General instructions

First of all, please read the above referenced resources and the [GSoC FAQ](https://developers.google.com/open-source/gsoc/faq). Pay special attention to the **Eligibility** section of the FAQ.

We strongly recommend to follow the recommended steps, see next section, closely. It is slightly differs from the steps given for the closed GSoC application period. 
The procedure reflects some of the lessons learnt in the GSOC 2020 campaign, so you may compare the recommended steps and scan the change history of the [GSoC 2020 live blog](https://discourse.joplinapp.org/t/gsoc-2020-live-blog/6219).

### Recommended steps

1. Join the [Joplin Forum](https://discourse.joplinapp.org), introduce yourself in a structured manner, share your GitHub username, and meet your fellow developers in the [GSoC category](https://discourse.joplinapp.org/c/gsoc). The subject of the topic shall contain your username, e.g. `_Introducing \<username>_`.
2. Read Student proposal guidelines and the [GSoD Student Manual](https://developers.google.com/season-of-docs/docs/tech-writer-guide)
3. Take a look at the [list of ideas](https://github.com/laurent22/joplin/blob/dev/readme/dev/gsoc/gsod2020/ideas.md). You can have you own idea added by posting it in the [Features category](https://discourse.joplinapp.org/c/features)
4. Come up with project that you're interested in and discuss it in [Features category](https://discourse.joplinapp.org/c/features) if a corresponding does not already exist.
5. Write a first draft and get someone to review it
    1. Remember: you must link to work such as commits in your proposal. A private place will be created within the forum for that purposes.  
    1. If you want to add functionality to the codebase or documentation, have it approved  [Features category](https://discourse.joplinapp.org/c/features)
    1. **IMPORTANT**: If you contribute to the codebase do only one contribution at a time and wait until it is approved. 
6. Submit your proposal to the mentors writing a private message at `@mentors` in the [Joplin Forum](https://discourse.joplinapp.org) and wait for their feedback
8. Submit proposal using [Google's web interface](https://summerofcode.withgoogle.com/) well ahead of the deadline. You can update it at anytime, even the final proposal.
9. Submit proof of enrolment well ahead of the deadline

Coming up with an interesting idea is probably the most difficult part. It should be something interesting for Joplin, for Open Source in general and for you. And it must be something that you can realistically achieve in the time available to you.

A good start is finding out what the most pressing issues are in the projects in which you are interested. Join the forum and subscribe to GitHub repository for that project or go into its discourse channel: meet developers and your potential mentor, as well as start learning the code-base. We recommend strongly getting involved in advance of the beginning of GSoC, and we will look favourably on applications from students who have already started to act like Open Source developers.

### Student proposal guidelines

A project proposal is what you will be judged upon. Write a clear proposal on what you plan to do, the scope of your project, and why we should choose you to do it. Proposals are the basis of the GSoC projects and therefore one of the most important things to do well. The proposal is not only the basis of our decision of which student to choose, it has also an effect on Google's decision as to how many student slots are assigned to Joplin.

Below is the application template:

> **Introduction**
>
> Every software project should solve a problem. Before offering the solution (your Google Summer of Code project), you should first define the problem. What’s the current state of things? What’s the issue you wish to solve and why? Then you should conclude with a sentence or two about your solution. Include links to discussions, features, or bugs that describe the problem further if necessary.
>
> **Project goals**
>
> Be short and to the point, and perhaps format it as a list. Propose a clear list of deliverables, explaining exactly what you promise to do and what you do not plan to do. “Future developments” can be mentioned, but your promise for the Google Summer of Code term is what counts.
>
> **Implementation**
>
> Be detailed. Describe what you plan to do as a solution for the problem you defined above. Include technical details, showing that you understand the technology. Illustrate key technical elements of your proposed solution in reasonable detail. Include writing unit tests throughout the coding period, as well as code documentation. These critical elements cannot be left to the last few weeks of the program. If user documentation will be required, or apidox, etc. these should be written during each week, not at the end.
>
> **Timeline**
>
> Show that you understand the problem, have a solution, have also broken it down into manageable parts, and that you have a realistic plan on how to accomplish your goal. Here you set expectations, so don’t make promises you can’t keep. A modest, realistic and detailed timeline is better than promising the impossible.
>
> If you have other commitments during GSoC, such as a job, vacation, exams, internship, seminars, or papers to write, disclose them here. GSoC should be treated like a full-time job, and we will expect approximately 40 hours of work per week. *If you have conflicts, explain how you will work around them.* If you are found to have conflicts which you did not disclose, you may be failed.
>
> Open and clear communication is of utmost importance. **Include your plans for communication in your proposal; daily if possible.** You will need to initiate weekly formal communication such as a blog post on to be agreed placed. Lack of communication will result in you being failed.
>
> **About me**
>
> Provide your contact information (IRC nick, email, IM, phone) and write a few sentences about you and why you think you are the best for this job. **Prior contributions to Joplin are required; list your commits.** Name people (other developers, students, professors) who can act as a reference for you. Mention your field of study if necessary. Now is the time to join the relevant irc/telegram channels, mail lists and blog feeds. We want you to be a part of our community, not just contribute your code.
>
> *Tell us if you are submitting proposals to other organizations, and whether or not you would choose Joplin if given the choice.*
>
> *Other things to think about:*
>
> - Are you comfortable working independently under a supervisor or mentor who is several thousand miles away, and perhaps 12 time zones away? How will you work with your mentor to track your work? Have you worked in this style before?
>
> - If your native language is not English, are you comfortable working closely with a supervisor whose native language is English? What is your native language, as that may help us find a mentor who has the same native language?
>
> - After you have written your proposal, you should get it reviewed. Do not rely on the Joplin mentors to do it for you via the web interface, although we will try to comment on every proposal. It is wise to ask a colleague or a developer to critique your proposal. Clarity and completeness are important.

### Accepted Students
Your primary responsibility is finishing your project under the guidance of your mentors. To do that, you must submit code regularly and stay in frequent and effective communication with your mentors and team. To pass the evaluations, you must do both the communication and the documentation.

All students will create a report page by tool up to their choice. Keep this up-to-date, as this is one of our primary evaluation tools.

## Instructions for mentors
### Ideas 
If you're a Joplin developer or motivated user and you wish to participate in Summer of Code, make a proposal in the [Features category of the Joplin Forum](https://discourse.joplinapp.org/c/features), based what your Joplin project needs.

If you wish to mentor, please read the [GSoD Mentor Guide](https://developers.google.com/season-of-docs/docs/admin-guide) and the [Season of Doc FAQ](https://developers.google.com/season-of-docs/docs/faq). Also, please contact the staff and get the go-ahead from them before editing the ideas page, adding your idea.

Your idea proposal should be a brief description of what the project is, what the desired goals would be, what the student should know and an email address for contact. Students are not required to follow your idea to the letter, so regard your proposal as inspiration for the students.

### Mentoring
Anyone developer can be a mentor if you meet the GSoD eligibility requirements. We will potentially assign a student to you who has never worked on such a large project and will need some help. Make sure you're up for the task. Mentoring takes time, and lots and lots of communication.

Before subscribing yourself as a mentor, please make sure that the staff is aware of that. Ask them to send the Summer of Code Administrators an email confirming your involvement in the team. This is just a formality to make sure you are a real person we can trust; the administrators cannot know all active developers by their Google account ID. Then drop us an message in the forum.

You will subscribe to the relevant tags in the forum to discuss ideas. You will need to read the proposals as they come in, and vote on the proposals. Daily communication is required with your student during the Community Bonding period, and multiple times per week during the doc development period.

Finally, know that we will never assign you to a project you do not want to work on. We will not assign you more projects than you can/want to take on either. And you will have a backup mentor, just in case something unforeseen takes place.

## Ideas

Please see below for a list of project ideas:

https://github.com/laurent22/joplin/blob/dev/readme/dev/gsoc/gsod2020/ideas.md