# Clipper authorisation mechanism

In order to access the clipper API, the client must use a token, which is a random string generated by the application.

There are two ways for applications to obtain this token:

## Get it from the user

The user can copy the token in the Clipper configuration page and provide it directly to the application. This is the simplest method.

## Request it programmatically

The token can also be requested programmatically, as is done for the web clipper extension. It works as below:

- The client calls `POST /auth`. The server responds with `{ auth_token: "AUTH_TOKEN" }`. This `auth_token` is different from the regular token - it is just used to authenticate the client.

- The application displays a message asking the user to Accept or Reject the access request.

- The clients calls `GET /auth/check?auth_token=AUTH_TOKEN` at regular intervals. Initially the server responds with `{ status: "waiting" }`, since we are waiting for the user to confirm or reject.

- Once the user accepts the request in the application, the server returns `{ status: "accepted", token: "API_TOKEN" }`.

- The client can now use this `API_TOKEN` to make requests.

- If the users rejects the request, the server returns `{ status: "rejected" }`, and the client can display an error message.