---
created: 2021-06-21T10:47:53.000+00:00
source_url: https://www.patreon.com/posts/share-notebooks-52748835
---

# Share notebooks and collaborate on them using Joplin Server 2.0

Since a few versions Joplin Server includes a way to share notebooks between users and collaborate on them - i.e. any participant can view or modify notes in the shared notebook. It's been present since version 2.x and the feature is getting close to be stable.

**How does it work?**

When connected to Joplin Server (or the upcoming Joplin Cloud service), a new "Share notebook" menu item is available when right-clicking on a notebook.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20210621-104753_0.png)

Click on it, and it will display a new dialog where you can add any number of recipients. Those recipients also need to be on the same Joplin Server instance. From this dialog you can also remove a recipient or unshare the whole notebook, in which case it will be removed from everybody's note collection, except yours.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20210621-104753_1.png)

Once this is done, the recipient(s) will receive a notification in Joplin the next time they synchronise their data:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20210621-104753_2.png)

Then, finally, once the invitation is accepted, Joplin will download all the shared notebooks and notes. A shared notebook is denoted by the usual Share icon. Now the invited user can read or modify the shared notes, add attachments, etc. and the changes will be visible to everyone with access to the notebook.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20210621-104753_3.png)

**What's the availability of the notebook sharing feature?**

The notebook sharing feature is available on Joplin Server and Joplin Cloud.

On desktop, you can share notebooks and of course view or modify any notebook that has been shared with you.

On mobile and CLI, you cannot currently share notebooks, but you can view or modify any notebook that has been shared with you.

**If I share a notebook with someone, what access do they have?**

Currently they have full access to the data, including reading, writing and deleting notebooks or notes. In a future version, access control might be implemented. For example, to only give read-only access to the shared notebook.

**What can actually be shared?**

All the sub-notebooks, notes and resources within the shared notebook are shared.

**Does it work with End-To-End-Encryption?**

Yes and no. It is possible to use the share notebook feature even with E2EE enabled, however any shared notebook or note will not be encrypted, otherwise you would have had to give your master key password to the people you share with, which you'd probably not want to do.

In a future version, this might be supported. For example by automatically creating a new master key for the shared notebook. You would then provide the recipients with that master key password.

**What can it be used for?**

Some ideas:

- Plan a trip with friends or within a small organisation. For example, the notes could contain the maps, hotel and flight reservations, etc. or any document or note relevant to the trip. And all participants would have access to them.

- Work on a project with colleagues. Everybody can access various work-related documents, add to them, modify them, etc. That could serve as a knowledge base for a project.

- Another possible use, which has been requested many times, is to support multiple profiles. You could create a main profile that have access to all notes, and in there create a Work and Personal notebook. Then you would create a separate account for work. You can then share your Work notebook with that other account. That way the work account will only have access to the Work notebooks. You can use this technique in various ways to split your notebooks between multiple accounts and ensure strict separation between datasets.